/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.settings;

import com.atlassian.core.util.PropertyUtils;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitColor;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMap;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.model.BrowserTweakerCache;
import com.brikit.themepress.settings.AbstractThemeProperties;
import com.brikit.themepress.settings.ThemePlugin;
import com.brikit.themepress.settings.ThemePropertiesCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ThemeProperties
extends AbstractThemeProperties
implements Serializable {
    public static final String BRIKIT_THEME_NAME = "brikitThemeName";
    public static final String BRIKIT_THEME_VERSION = "brikitThemeVersion";
    public static final String PRIMARY_COLOR = "primaryColor";
    public static final String SECONDARY_COLOR = "secondaryColor";
    public static final String TERTIARY_COLOR = "tertiaryColor";
    public static final String DARK_COLOR = "darkColor";
    public static final String MEDIUM_COLOR = "mediumColor";
    public static final String LIGHT_COLOR = "lightColor";
    public static final String DARK_GRAY_COLOR = "darkGrayColor";
    public static final String MEDIUM_GRAY_COLOR = "mediumGrayColor";
    public static final String LIGHT_GRAY_COLOR = "lightGrayColor";
    public static final String WHITE_COLOR = "whiteColor";
    public static final String BODY_TEXT_COLOR = "brikitBodyColor";
    public static final String LINK_TEXT_COLOR = "brikitLinkColor";
    public static final String CANVAS_BACKGROUND_COLOR = "brikitBackgroundBackgroundColor";
    public static final String TYPE_KIT_ID = "brikitTypekitId";
    public static final String TYPOGRAPHY_COM_CSS_KEY = "brikitTypographyKey";
    public static final String FONT_FAMILIES = "brikitFontFamilies";
    public static final String FONTS_COM_ID = "brikitFontsComId";
    public static final String STYLESHEET_LINKS = "brikitStylesheetLinks";
    public static final String HIDE_COMMENTS_FOR_ANONYMOUS = "brikitHideCommentsForAnonymous";
    public static final String HIDE_LABELS_FOR_ANONYMOUS = "brikitHideLabelsForAnonymous";
    public static final String LOGO_KEY = "brikitLogo";
    public static final String LOGO_HEIGHT_KEY = "brikitLogoHeight";
    public static final String LOGO_WIDTH_KEY = "brikitLogoWidth";
    public static final String SPACES_CAN_OVERRIDE_LOGO = "brikitLogoSpaceCanOverride";
    public static final String NEW_WINDOW_FOR_OUTSIDE_LINKS_KEY = "brikitNewWindowForOutsideLinks";
    public static final String ALLOW_HEADER_FOR = "brikitAllowHeader";
    public static final String SHOW_HEADER_BY_DEFAULT = "brikitShowHeaderByDefault";
    public static final String TOOLBAR_RELOCATE = "brikitToolbarRelocate";
    public static final String GOOGLE_ANALYTICS_ID = "googleAnalyticsID";
    public static final String GOOGLE_ANALYTICS_GID = "googleAnalyticsGID";
    public static final String GOOGLE_TAG_MANAGER_ID = "googleTagManagerID";
    public static final String FLAG_ANCESTOR_LINKS_KEY = "brikitFlagAncestorLinks";
    public static final String CSS_EXTRAS_ALL_MEDIA = "brikitCustomCSS";
    public static final String CSS_EXTRAS_PRINT_MEDIA = "brikitCustomCSSPrintMedia";
    public static final String JAVASCRIPT_EXTRAS = "brikitCustomJavaScript";
    public static final String STICKY_HEADER = "brikitStickyHeader";
    public static final String QUICK_SEARCH_RELOCATE = "brikitQuickSearchRelocate";
    public static final String NAVIGATOR_WIDTH = "brikitLeftNavSidebarWidth";
    public static final String FONT_FAMILY_SUFFIX = "FontFamily";
    public static final String FONT_FAMILY_NAME_PREFIX = "fontFamily";
    public static final String ANONYMOUS = "anonymous";
    public static final String NOBODY = "nobody";
    protected String themeName;
    protected Map<String, String> themeColorsToRGB;
    protected Map<String, String> rgbColorsToTheme;
    protected Map<String, String> fontFamilies;

    protected ThemeProperties(String themeName) {
        this.themeName = themeName;
    }

    public static ThemeProperties getThemeProperties(String themeName) {
        try {
            return ThemePropertiesCache.getThemeProperties(themeName);
        }
        catch (Exception ex) {
            BrikitLog.logError((String)("Unable to read theme properties for " + themeName), (Exception)ex);
            return new ThemeProperties("");
        }
    }

    public static void reset(String themeName) throws ExecutionException {
        ThemePropertiesCache.reset(themeName);
        BrowserTweakerCache.reset(themeName);
    }

    public String headerAllowedFor() {
        return this.get(ALLOW_HEADER_FOR);
    }

    public boolean headerAllowedForAnonymous() {
        return ANONYMOUS.equals(this.headerAllowedFor());
    }

    public boolean isSearchBoxInHeader() {
        return this.getBoolean(QUICK_SEARCH_RELOCATE);
    }

    public boolean isStickyHeader() {
        return this.getBoolean(STICKY_HEADER);
    }

    public String convertColor(String color) {
        String namedColor;
        if (BrikitString.isSet((String)color) && BrikitString.isSet((String)(namedColor = this.getColorValue(color)))) {
            color = namedColor;
        }
        return color;
    }

    public String convertFontFamilies() throws IOException, ExecutionException {
        ThemePlugin theme = ThemePlugin.readTheme(this.getThemeName());
        HashMap<String, String> namesToFamilies = new HashMap<String, String>();
        HashMap<String, String> comparableFamiliesToNames = new HashMap<String, String>();
        int familyNumber = 1;
        for (Object key : this.defaultSettings().keySet()) {
            String family;
            Object property;
            if (!(key instanceof String) || !((String)(property = (String)key)).endsWith(FONT_FAMILY_SUFFIX) || !BrikitString.isSet((String)(family = this.get((String)property)))) continue;
            String comparableFamily = family.replaceAll("\\s+", "").toLowerCase();
            String name = (String)comparableFamiliesToNames.get(comparableFamily);
            if (!BrikitString.isSet((String)name)) {
                name = FONT_FAMILY_NAME_PREFIX + familyNumber;
                comparableFamiliesToNames.put(comparableFamily, name);
                namesToFamilies.put(name, family);
                ++familyNumber;
            }
            theme.updateProperty((String)property, "$" + name);
        }
        StringBuilder familyBuilder = new StringBuilder();
        ArrayList familyNames = new ArrayList(namesToFamilies.keySet());
        Collections.sort(familyNames);
        for (String name : familyNames) {
            familyBuilder.append(name).append(": ").append((String)namesToFamilies.get(name)).append(";");
        }
        String fontFamiliesString = familyBuilder.toString();
        theme.updateProperty(FONT_FAMILIES, fontFamiliesString);
        ThemeProperties.reset(this.getThemeName());
        return fontFamiliesString;
    }

    @Override
    protected Map defaultSettings() {
        try {
            String fileContents = BrikitFile.readFile((String)this.getPropertiesFile());
            Properties props = new Properties();
            AbstractThemeProperties.addBackwardCompatibilityDefaults(props);
            props.load(new StringReader(fileContents));
            Collection<Object> values = props.values();
            while (values.remove("")) {
            }
            return props;
        }
        catch (FileNotFoundException e) {
            BrikitLog.logError((String)("Failed to read theme settings from file: " + this.getPropertiesFile()), (Exception)e);
            return new Properties();
        }
        catch (IOException e) {
            BrikitLog.logError((String)("Failed to read theme settings from file: " + this.getPropertiesFile()), (Exception)e);
            return new Properties();
        }
    }

    public String getBodyTextColor() {
        return this.get(BODY_TEXT_COLOR);
    }

    public String getCanvasBackgroundColor() {
        return this.get(CANVAS_BACKGROUND_COLOR);
    }

    public String getCanvasBackgroundColorValue() {
        return this.getColorValue(this.getCanvasBackgroundColor());
    }

    public String getColorName(String anRGB) {
        if (!BrikitString.isSet((String)anRGB) || anRGB.equals("#")) {
            return anRGB;
        }
        String name = this.getRgbColorsToTheme().get(anRGB);
        if (name == null) {
            name = this.getRgbColorsToTheme().get(anRGB.startsWith("#") ? anRGB.substring(1) : "#" + anRGB);
        }
        if (name == null) {
            name = (String)BrikitColor.getRgbColorsToName().get(anRGB);
        }
        if (name == null) {
            name = (String)BrikitColor.getRgbColorsToName().get(anRGB.startsWith("#") ? anRGB.substring(1) : "#" + anRGB);
        }
        return name == null ? anRGB : name;
    }

    public String getColorValue(String aColorName) {
        if (!BrikitString.isSet((String)aColorName) || aColorName.equals("$")) {
            return aColorName;
        }
        if ("transparent".equals(aColorName)) {
            return aColorName;
        }
        for (Map.Entry<String, String> entry : this.getThemeColorsToRGB().entrySet()) {
            if (!entry.getKey().equals(aColorName.startsWith("$") ? aColorName : "$" + aColorName)) continue;
            return entry.getValue().toString();
        }
        for (Map.Entry<String, String> entry : BrikitColor.getRgbColorsToName().entrySet()) {
            if (!entry.getValue().equals(aColorName.startsWith("$") ? aColorName.substring(1) : aColorName)) continue;
            return entry.getKey().toString();
        }
        return null;
    }

    public List<String> getCssFileNamesForAllMedia() {
        return BrikitString.split((String)this.getCssFilesForAllMedia());
    }

    public String getCssFilesForAllMedia() {
        return this.get(CSS_EXTRAS_ALL_MEDIA);
    }

    public String getCssFilesForPrintMedia() {
        return this.get(CSS_EXTRAS_PRINT_MEDIA);
    }

    public String getDarkColor() {
        return this.get(DARK_COLOR);
    }

    public String getDarkGrayColor() {
        return this.get(DARK_GRAY_COLOR);
    }

    public Map<String, String> getFontFamilies() throws IOException, ExecutionException {
        if (this.fontFamilies == null) {
            String familyString = this.get(FONT_FAMILIES);
            if (!BrikitString.isSet((String)familyString)) {
                familyString = this.convertFontFamilies();
            }
            this.fontFamilies = new HashMap<String, String>();
            BrikitList familySpecs = BrikitString.split((String)familyString, (String)";");
            for (String spec : familySpecs) {
                int split = (spec = BrikitString.trimToString((String)spec)).indexOf(":");
                if (split == -1) continue;
                String familyName = spec.substring(0, split).trim();
                String fontStack = spec.substring(split + 1).trim();
                this.fontFamilies.put(familyName, fontStack);
            }
        }
        return this.fontFamilies;
    }

    public List<String> getFontFamilyNamesForPickList() throws IOException, ExecutionException {
        ArrayList<String> names = new ArrayList<String>();
        names.add("");
        names.addAll((Collection<String>)new BrikitMap(this.getNamedFontFamilyVariables()).sortedKeys());
        return names;
    }

    public String getFontsComId() {
        return BrikitString.trimToNull((String)this.get(FONTS_COM_ID));
    }

    public String getGoogleAnalyticsGID() {
        return this.get(GOOGLE_ANALYTICS_GID);
    }

    public String getGoogleAnalyticsID() {
        return this.get(GOOGLE_ANALYTICS_ID);
    }

    public String getGoogleTagManagerID() {
        return this.get(GOOGLE_TAG_MANAGER_ID);
    }

    public String getJavascriptFiles() {
        return this.get(JAVASCRIPT_EXTRAS);
    }

    public String getLightColor() {
        return this.get(LIGHT_COLOR);
    }

    public String getLightGrayColor() {
        return this.get(LIGHT_GRAY_COLOR);
    }

    public String getLinkTextColor() {
        return this.get(LINK_TEXT_COLOR);
    }

    public String getLogo() {
        return this.get(LOGO_KEY);
    }

    public String getLogoHeight() {
        return this.get(LOGO_HEIGHT_KEY);
    }

    public String getLogoWidth() {
        return this.get(LOGO_WIDTH_KEY);
    }

    public String getMediumColor() {
        return this.get(MEDIUM_COLOR);
    }

    public String getMediumGrayColor() {
        return this.get(MEDIUM_GRAY_COLOR);
    }

    public String getNavigatorWidth() {
        return this.get(NAVIGATOR_WIDTH);
    }

    public Map<String, String> getThemeColorsToRGB() {
        if (this.themeColorsToRGB == null) {
            this.themeColorsToRGB = new HashMap<String, String>();
            this.themeColorsToRGB.put("$primaryColor", this.getPrimaryColor());
            this.themeColorsToRGB.put("$secondaryColor", this.getSecondaryColor());
            this.themeColorsToRGB.put("$tertiaryColor", this.getTertiaryColor());
            this.themeColorsToRGB.put("$darkColor", this.getDarkColor());
            this.themeColorsToRGB.put("$mediumColor", this.getMediumColor());
            this.themeColorsToRGB.put("$lightColor", this.getLightColor());
            this.themeColorsToRGB.put("$darkGrayColor", this.getDarkGrayColor());
            this.themeColorsToRGB.put("$mediumGrayColor", this.getMediumGrayColor());
            this.themeColorsToRGB.put("$lightGrayColor", this.getLightGrayColor());
            this.themeColorsToRGB.put("$whiteColor", this.getWhiteColor());
        }
        return this.themeColorsToRGB;
    }

    public Map<String, String> getNamedFontFamilyVariables() throws IOException, ExecutionException {
        HashMap<String, String> namedFamilies = new HashMap<String, String>();
        for (String name : this.getFontFamilies().keySet()) {
            String stack = this.getFontFamilies().get(name);
            BrikitList fonts = new BrikitList((List)BrikitString.splitCommaSeparated((String)stack));
            if (fonts.isEmpty()) continue;
            String fontName = (String)fonts.first();
            Pattern pattern = Pattern.compile("^['\"\\s]*(.+?)['\"\\s]*$");
            Matcher matcher = pattern.matcher(fontName);
            if (!matcher.find()) continue;
            fontName = matcher.group(1);
            namedFamilies.put("$" + name, fontName);
        }
        return namedFamilies;
    }

    public String getPrimaryColor() {
        return this.get(PRIMARY_COLOR);
    }

    @Override
    protected String getPropertiesFile() {
        return ThemePlugin.getPropertiesFileFullPath(this.getThemeName()).getAbsolutePath();
    }

    public Map<String, String> getRgbColorsToTheme() {
        if (this.rgbColorsToTheme == null) {
            this.rgbColorsToTheme = new BrikitMap(this.getThemeColorsToRGB()).invert();
        }
        return this.rgbColorsToTheme;
    }

    public String getSecondaryColor() {
        return this.get(SECONDARY_COLOR);
    }

    public String getStylesheetLinks() {
        return BrikitString.trimToNull((String)this.get(STYLESHEET_LINKS));
    }

    public String getTertiaryColor() {
        return this.get(TERTIARY_COLOR);
    }

    public String getThemeName() {
        return this.themeName;
    }

    public String getThemeNameInProperties() {
        return this.get(BRIKIT_THEME_NAME);
    }

    public String getThemeVersion() {
        return BrikitString.trimToString((String)this.get(BRIKIT_THEME_VERSION));
    }

    public String getTypeKitId() {
        return BrikitString.trimToNull((String)this.get(TYPE_KIT_ID));
    }

    public String getTypographyKey() {
        return BrikitString.trimToNull((String)this.get(TYPOGRAPHY_COM_CSS_KEY));
    }

    public String getWhiteColor() {
        return this.get(WHITE_COLOR);
    }

    protected Properties resolveSelfReferencingProperties(String fileContents) throws IOException, ExecutionException {
        Properties props;
        String prev;
        Map<String, String> fontFamilies = this.getFontFamilies();
        int count = 0;
        do {
            props = new Properties();
            props.load(new StringReader(fileContents));
            props.putAll(fontFamilies);
            prev = fileContents;
            fileContents = Confluence.getRenderedVelocityContent((String)fileContents, (Map)props);
            if (count++ <= 20) continue;
            BrikitLog.logError((String)"Probably infinite loop detected in theme properties references. Twenty passes and still changing.");
            break;
        } while (!prev.equals(fileContents));
        ThemeProperties.addBackwardCompatibilityDefaults(props);
        return props;
    }

    public Map settingsAfterSubstitution() throws ExecutionException {
        try {
            String fileContents = BrikitFile.readFile((String)this.getPropertiesFile());
            return this.resolveSelfReferencingProperties(fileContents);
        }
        catch (FileNotFoundException e) {
            BrikitLog.logError((String)("Failed to read theme settings from file: " + this.getPropertiesFile()), (Exception)e);
            return new Properties();
        }
        catch (IOException e) {
            BrikitLog.logError((String)("Failed to read theme settings from file: " + this.getPropertiesFile()), (Exception)e);
            return new Properties();
        }
    }

    public Properties settingsBeforeSubstitution() throws IOException {
        try {
            File location = new File(this.getPropertiesFile());
            return PropertyUtils.getPropertiesFromStream((InputStream)new FileInputStream(location));
        }
        catch (FileNotFoundException e) {
            BrikitLog.logError((String)("Failed to read theme settings from file: " + this.getPropertiesFile()), (Exception)e);
            return new Properties();
        }
    }

    public boolean shouldFlagAncestorLinks() {
        return this.getBoolean(FLAG_ANCESTOR_LINKS_KEY, true);
    }

    public boolean shouldHideCommentsForAnonymous() {
        return this.getBoolean(HIDE_COMMENTS_FOR_ANONYMOUS);
    }

    public boolean shouldHideLabelsForAnonymous() {
        return this.getBoolean(HIDE_LABELS_FOR_ANONYMOUS);
    }

    public boolean shouldOpenNewWindowForOutsideLinks() {
        return this.getBoolean(NEW_WINDOW_FOR_OUTSIDE_LINKS_KEY, true);
    }

    public boolean shouldRelocateToolbar() {
        return this.getBoolean(TOOLBAR_RELOCATE);
    }

    public String showHeaderByDefault() {
        String setting = this.get(SHOW_HEADER_BY_DEFAULT);
        return BrikitString.isSet((String)setting) ? setting : NOBODY;
    }

    public boolean spacesCanOverrideLogo() {
        return this.getBoolean(SPACES_CAN_OVERRIDE_LOGO);
    }
}

