/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.settings;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.user.util.FileUtils;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.develop.ExternalDevelopmentMode;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.theme.ThemeResourceServlet;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.core.util.BrikitZipFile;
import com.brikit.themepress.designer.ThemePluginAccess;
import com.brikit.themepress.designer.ThemeUndoStack;
import com.brikit.themepress.events.cluster.ThemeUpdateClusterEvent;
import com.brikit.themepress.settings.ThemeProperties;
import com.brikit.themepress.settings.ThemePropertiesCache;
import com.brikit.themepress.util.ThemePress;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class ThemePlugin {
    public static final String PROPERTIES_FILE = "theme.properties";
    public static final String EXTERNAL_DEV_THEMES_DIRECTORY = "designs" + BrikitFile.separator() + "themes";
    public static final String IMAGES_DIRECTORY = "images";
    public static final String CSS_EXTRAS_IGNORE = "zenExtraCSSIgnore";
    public static final String CSS_EXTRAS_CREATE = "zenExtraCSSCreate";
    public static final String CSS_EXTRAS_REMOVE = "zenExtraCSSRemove";
    public static final String JAVASCRIPT_EXTRAS_IGNORE = "zenExtraJavascriptIgnore";
    public static final String JAVASCRIPT_EXTRAS_CREATE = "zenExtraJavascriptCreate";
    public static final String JAVASCRIPT_EXTRAS_REMOVE = "zenExtraJavascriptRemove";
    public static final String ZEN_EXTRA_FILES = "zenExtraFiles";
    public static final String FONTS_DIRECTORY = "fonts";
    public static final String SPLASH_THEME = "splash";
    public static final String VANILLA_THEME = "vanilla";
    public static final List<String> BUILT_IN_THEMES = Arrays.asList("splash", "vanilla");
    public static final List<String> IMAGE_EXTENSIONS = Arrays.asList("png", "gif", "jpg");
    protected static Map<String, ThemePlugin> themePlugins;
    protected File themeFolder;
    protected String themeName;

    public ThemePlugin(File themeFolder) throws IOException {
        this.themeFolder = themeFolder;
        this.themeName = themeFolder.getName();
    }

    public static void apply(String themeName, String themePropertiesJSON) throws IOException, ExecutionException {
        ThemePlugin theme = ThemePlugin.readTheme(themeName);
        JSONObject json = new JSONObject(themePropertiesJSON);
        Iterator it = json.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = json.get(key);
            if (ZEN_EXTRA_FILES.equals(key)) {
                theme.writeZenExtraFiles((JSONObject)value);
                continue;
            }
            if (CSS_EXTRAS_CREATE.equals(key) || JAVASCRIPT_EXTRAS_CREATE.equals(key) || CSS_EXTRAS_REMOVE.equals(key) || JAVASCRIPT_EXTRAS_REMOVE.equals(key)) continue;
            theme.updateProperty(key, value.toString());
        }
        ThemeProperties.reset(themeName);
    }

    public static void apply(String themeName, String property, String value) throws IOException, ExecutionException {
        ThemePlugin theme = ThemePlugin.readTheme(themeName);
        theme.updateProperty(property, value);
        ThemeProperties.reset(themeName);
    }

    public static void copy(String themeName, String newthemeName) throws Exception {
        ThemePlugin.copy(themeName, newthemeName, false);
    }

    public static void copy(String themeName, String newThemeName, boolean force) throws Exception {
        if (!force && ThemePlugin.isInstalled(newThemeName)) {
            throw new Exception(newThemeName + " already exists");
        }
        File sourceThemeFile = ThemePlugin.getThemeDirectory(themeName);
        File targetThemeFile = ThemePlugin.getThemeDirectory(newThemeName);
        BrikitFile.copy((File)sourceThemeFile, (File)targetThemeFile);
        BrikitFile.removeFile((File)new File(targetThemeFile, "sprite"));
        BrikitFile.removeFile((File)new File(targetThemeFile, "temp"));
        ThemePlugin theme = new ThemePlugin(targetThemeFile);
        theme.updateProperty("brikitThemeName", newThemeName);
        ThemeUndoStack.getUndoStack(newThemeName).reset();
        ThemePlugin.resetThemes();
    }

    public static List<String> getAvailableThemes() {
        List<String> themes = ExternalDevelopmentMode.isDeveloperMode() ? ThemePlugin.getExternalDevelopmentModeThemes() : ThemePlugin.getPluginThemeNames();
        Collections.sort(themes, String.CASE_INSENSITIVE_ORDER);
        return themes;
    }

    protected static List<String> getExternalDevelopmentModeThemes() {
        ArrayList<String> themes = new ArrayList<String>();
        File themesDirectory = ThemePlugin.getExternalDevelopmentThemesDirectory();
        for (File file : themesDirectory.listFiles()) {
            if (!file.isDirectory() || !new File(file, PROPERTIES_FILE).exists()) continue;
            themes.add(file.getName());
        }
        return themes;
    }

    public static File getExternalDevelopmentThemesDirectory() {
        return new File(ThemeResourceServlet.getServerFileLocation((String)EXTERNAL_DEV_THEMES_DIRECTORY));
    }

    public static File getImageDirectory(String themeName) {
        return ThemePlugin.getThemeResourceFile(themeName, IMAGES_DIRECTORY);
    }

    public static List<String> getImageExtensions() {
        return IMAGE_EXTENSIONS;
    }

    public static File getImageLocation(String themeName, String imageName) {
        return new File(ThemePlugin.getImageDirectory(themeName), imageName);
    }

    public static List<String> getImageNames(File aDirectory) {
        if (!aDirectory.exists()) {
            return new ArrayList<String>();
        }
        Object[] filenames = aDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                filename = filename.toLowerCase();
                return ThemePlugin.getImageExtensions().contains(BrikitFile.fileExtension((String)filename).toLowerCase());
            }
        });
        BrikitList imageNames = new BrikitList(filenames);
        Collections.sort(imageNames, String.CASE_INSENSITIVE_ORDER);
        return imageNames;
    }

    public static List<String> getImageNames(String themeName) {
        return ThemePlugin.getImageNames(ThemePlugin.getImageDirectory(themeName));
    }

    public static Map<String, Image> getImages(File aDirectory) {
        HashMap<String, Image> images = new HashMap<String, Image>();
        if (!aDirectory.exists()) {
            return images;
        }
        Object[] filenames = aDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                filename = filename.toLowerCase();
                return ThemePlugin.getImageExtensions().contains(BrikitFile.fileExtension((String)filename).toLowerCase());
            }
        });
        BrikitList imageNames = new BrikitList(filenames);
        Collections.sort(imageNames, String.CASE_INSENSITIVE_ORDER);
        for (String name : imageNames) {
            File imageFile = new File(aDirectory, name);
            try {
                BufferedImage image = ImageIO.read(imageFile);
                images.put(name, image);
            }
            catch (IOException iOException) {}
        }
        return images;
    }

    public static Map<String, Image> getImages(String themeName) {
        return ThemePlugin.getImages(ThemePlugin.getImageDirectory(themeName));
    }

    public static List<File> getInstalledThemeFolders() {
        ArrayList<File> files = new ArrayList<File>();
        File pluginDirectory = ThemePress.getThemePluginLocation();
        for (File file : pluginDirectory.listFiles()) {
            if (!file.isDirectory() || file.getName().startsWith(".")) continue;
            files.add(file);
        }
        return files;
    }

    public static List<String> getPermittedThemes() {
        ArrayList<String> themes = new ArrayList<String>();
        for (String theme : ThemePlugin.getAvailableThemes()) {
            if (!ThemePluginAccess.hasThemeAccess(theme)) continue;
            themes.add(theme);
        }
        return themes;
    }

    public static ThemePlugin getPlugin(String themeName) {
        return ThemePlugin.getThemePlugins().get(themeName);
    }

    public static List<String> getPluginThemeNames() {
        return new ArrayList<String>(ThemePlugin.getThemePlugins().keySet());
    }

    public static File getPluginThemeZipFile(String themeName) {
        String filename = themeName + (themeName.endsWith(".zip") ? "" : ".zip");
        return new File(ThemePlugin.getThemeDirectory(), filename);
    }

    public static File getPropertiesFileFullPath(String themeName) {
        return new File(ThemePlugin.getThemeDirectory(themeName), PROPERTIES_FILE);
    }

    protected static File getPropertiesLocation(String themeName) {
        return new File(ExternalDevelopmentMode.isDeveloperMode() ? EXTERNAL_DEV_THEMES_DIRECTORY : "themes", themeName);
    }

    public static File getThemeDirectory() {
        return ExternalDevelopmentMode.isDeveloperMode() ? ThemePlugin.getExternalDevelopmentThemesDirectory() : ThemePress.getThemePluginLocation();
    }

    public static File getThemeDirectory(String themeName) {
        return new File(ThemePlugin.getThemeDirectory(), themeName);
    }

    public static File getThemeResourceFile(String themeName, String resourcePath) {
        File themeLocation = new File(ThemePlugin.getThemeDirectory(), themeName);
        return new File(themeLocation, resourcePath);
    }

    protected static String getThemeName(File file) {
        return file.getName().substring(0, file.getName().length() - 4);
    }

    protected static Map<String, ThemePlugin> getThemePlugins() {
        if (themePlugins == null) {
            ThemePropertiesCache.reset();
            themePlugins = new HashMap<String, ThemePlugin>();
            if (ThemePlugin.getInstalledThemeFolders().isEmpty()) {
                try {
                    ThemePlugin.installBuiltInPlugins(true);
                }
                catch (Exception ex) {
                    BrikitLog.logError((String)"Failed to install built-in themes.", (Exception)ex);
                }
            }
            for (File file : ThemePlugin.getInstalledThemeFolders()) {
                try {
                    ThemePlugin.loadPlugin(file);
                }
                catch (Exception ex) {
                    BrikitLog.logWarning((String)("Failed to process theme plug-in: " + file.getName() + " due to: " + ex.getMessage()));
                }
            }
        }
        return themePlugins;
    }

    public static void installBuiltInPlugins(boolean reinstall) throws Exception {
        if (ExternalDevelopmentMode.isDeveloperMode()) {
            return;
        }
        for (String theme : BUILT_IN_THEMES) {
            File outputFile = new File(ThemePress.getThemePluginLocation(), theme + ".zip");
            if (reinstall && !outputFile.exists()) continue;
            BrikitLog.log((String)("Installing theme: " + theme));
            InputStream inputStream = ThemeResourceServlet.themeResourceFromJar((String)(theme + ".zip"));
            BrikitFile.writeInputStream((InputStream)inputStream, (File)outputFile);
            ThemePlugin.unpackPlugin(outputFile);
        }
    }

    public static boolean isBuiltInTheme(String themeName) {
        return new BrikitList(BUILT_IN_THEMES).contains((Object)themeName);
    }

    public static boolean isInstalled(String themeName) {
        return BrikitString.isSet((String)themeName) && ThemePlugin.getAvailableThemes().contains(themeName);
    }

    public static boolean isPlugin(String themeName) {
        return ThemePlugin.getPlugin(themeName) != null;
    }

    public static void loadPlugin(File theme) throws Exception {
        ThemePlugin candidate = new ThemePlugin(theme);
        candidate.validateThemePlugin();
        ThemePlugin.getThemePlugins().put(candidate.getThemeName(), candidate);
    }

    protected static void moveFiles(String fileList, File sourceDir, File targetDir) {
        for (String filenames : BrikitString.split((String)fileList)) {
            try {
                BrikitList fromTo = BrikitString.split((String)filenames, (String)"/");
                File fromFile = new File(sourceDir, (String)fromTo.get(0));
                File toFile = new File(targetDir, (String)fromTo.get(1));
                fromFile.renameTo(toFile);
            }
            catch (Exception exception) {}
        }
    }

    public static ThemePlugin readTheme(String themeName) throws IOException {
        File themeFile = ThemePlugin.getThemeDirectory(themeName);
        return new ThemePlugin(themeFile);
    }

    public static void reloadThemes() {
        themePlugins = null;
    }

    public static void removePlugin(String themeName) {
        ThemePlugin.getThemePlugins().remove(themeName);
        File zip = ThemePlugin.getPluginThemeZipFile(themeName);
        zip.delete();
        ThemePlugin.removeUnpackedPlugin(themeName);
        ThemeUndoStack.getUndoStack(themeName).reset();
        ThemePlugin.resetThemes();
    }

    public static void removeUnpackedPlugin(String themeName) {
        FileUtils.deleteDir((File)new File(ThemePress.getThemePluginLocation(), themeName));
    }

    public static void resetThemes() {
        ThemePlugin.reloadThemes();
        ThemeUpdateClusterEvent event = new ThemeUpdateClusterEvent(new Object());
        Confluence.getEventPublisher().publish((Object)event);
    }

    public static void removeAllThemes() {
        List<String> themes = ThemePlugin.getAvailableThemes();
        for (String theme : themes) {
            ThemePlugin.removePlugin(theme);
        }
        ThemePress.resetCaches();
    }

    public static void removeBuiltInThemes() {
        for (String theme : BUILT_IN_THEMES) {
            ThemePlugin.removePlugin(theme);
        }
        ThemePress.resetCaches();
    }

    public static void unpackPlugin(File themeZipFilePath) throws Exception {
        String themeName = ThemePlugin.getThemeName(themeZipFilePath);
        BrikitZipFile zip = new BrikitZipFile(themeZipFilePath, new File(themeZipFilePath.getParent(), themeName));
        ThemePlugin.removeUnpackedPlugin(themeName);
        zip.extractAll();
        ThemePlugin candidate = new ThemePlugin(zip.getTargetDirectory());
        candidate.validateThemePlugin();
        candidate.updateProperty("brikitThemeName", themeName);
    }

    public static void uploadThemePlugin(File pluginFile) throws Exception {
        ThemePlugin.uploadThemePlugin(pluginFile, BrikitFile.nameWithoutExtension((File)pluginFile));
    }

    public static void uploadThemePlugin(File pluginFile, String filename) throws Exception {
        String themeName = BrikitFile.nameWithoutExtension((String)filename);
        ThemePlugin.removePlugin(themeName);
        File themeFile = new File(ThemePlugin.getThemeDirectory(), filename);
        pluginFile.renameTo(themeFile);
        ThemePlugin.unpackPlugin(themeFile);
        ThemeUndoStack.getUndoStack(themeName).reset();
    }

    public static File zipThemeContents(String themeName) throws Exception {
        File destination = BrikitFile.getConfluenceTempDirectoryPath((String)themeName);
        BrikitFile.copy((File)ThemePlugin.getThemeDirectory(themeName), (File)destination);
        BrikitFile.removeFile((File)new File(destination, "sprite"));
        BrikitFile.removeFile((File)new File(destination, "temp"));
        File zipFile = BrikitFile.getConfluenceTempDirectoryPath((String)(themeName + ".zip"));
        BrikitZipFile.createZipFile((File)destination, (File)zipFile);
        BrikitFile.removeFile((File)destination);
        return zipFile;
    }

    public File absolutePath(String filePath) {
        return new File(this.getThemeFolder(), filePath);
    }

    protected File getThemeFile(String fileName, boolean isDirectory) {
        File file = new File(this.getThemeFolder(), fileName);
        return file.exists() && file.isDirectory() == isDirectory ? file : null;
    }

    protected File getThemeFolder() {
        return this.themeFolder;
    }

    protected File getThemeFontsPath() {
        return this.getThemeFile(FONTS_DIRECTORY, true);
    }

    public File getThemeImagesPath() {
        return this.getThemeFile(IMAGES_DIRECTORY, true);
    }

    protected String getThemeName() {
        return this.themeName;
    }

    protected ThemeProperties getThemeProperties() {
        return ThemeProperties.getThemeProperties(this.getThemeName());
    }

    protected File getThemePropertiesPath() {
        return this.getThemeFile(PROPERTIES_FILE, false);
    }

    protected void removeZenExtraFiles(String category, String directoryName, JSONObject filesJSON) {
        JSONArray files = filesJSON.getJSONArray(category);
        for (int i = 0; i < files.length(); ++i) {
            JSONObject file = files.getJSONObject(i);
            String filename = file.getString("filename");
            File directory = new File(this.getThemeFolder(), directoryName);
            BrikitFile.removeFile((File)new File(directory, filename));
        }
    }

    public void updateProperty(String property, String value) throws IOException {
        String properties = BrikitFile.readFile((File)this.getThemePropertiesPath());
        value = value.replaceAll("[\\n\\r]+", "");
        String regex = "^" + property + "\\s*=[^\\n]*";
        Matcher propertyMatcher = Pattern.compile(regex, 8).matcher(properties);
        properties = propertyMatcher.find() ? propertyMatcher.replaceFirst(Matcher.quoteReplacement(property + "=" + value)) : properties + BrikitString.lineSeparator() + property + "=" + value;
        BrikitFile.write((String)properties, (File)this.getThemePropertiesPath());
    }

    protected void validateThemePlugin() throws Exception {
        String help = " Make sure you zip only the theme.properties file and the images and fonts folders, and not the directory that contains them.";
        if (this.getThemePropertiesPath() == null) {
            BrikitLog.logWarning((String)("Missing theme.properties file in theme plug-in: " + this.getThemeName()));
            throw new Exception(this.getThemeName() + " is missing the theme.properties file." + help);
        }
        ArrayList<String> taken = new ArrayList<String>();
        for (File themeFile : ThemePlugin.getInstalledThemeFolders()) {
            String themeName = themeFile.getName();
            if (taken.contains(themeName) && this.getThemeName().equals(themeName)) {
                BrikitLog.logWarning((String)("Found duplicate theme named: " + themeName));
                throw new Exception(themeName + " is already used by another theme.");
            }
            taken.add(themeName);
        }
        if (this.getThemeImagesPath() == null) {
            BrikitLog.logWarning((String)("Missing images folder in theme plug-in: " + this.getThemeName()));
            throw new Exception(this.getThemeName() + " is missing the images folder." + help);
        }
    }

    protected void writeZenExtraFiles(JSONObject filesJSON) throws IOException {
        this.writeZenExtraFiles("brikitCustomCSS", "css", filesJSON);
        this.writeZenExtraFiles("brikitCustomCSSPrintMedia", "css", filesJSON);
        this.writeZenExtraFiles(CSS_EXTRAS_IGNORE, "css", filesJSON);
        this.writeZenExtraFiles(CSS_EXTRAS_CREATE, "css", filesJSON);
        this.removeZenExtraFiles(CSS_EXTRAS_REMOVE, "css", filesJSON);
        this.writeZenExtraFiles("brikitCustomJavaScript", "scripts", filesJSON);
        this.writeZenExtraFiles(JAVASCRIPT_EXTRAS_IGNORE, "scripts", filesJSON);
        this.writeZenExtraFiles(JAVASCRIPT_EXTRAS_CREATE, "scripts", filesJSON);
        this.removeZenExtraFiles(JAVASCRIPT_EXTRAS_REMOVE, "scripts", filesJSON);
    }

    protected void writeZenExtraFiles(String category, String directoryName, JSONObject filesJSON) throws IOException {
        JSONArray files = filesJSON.getJSONArray(category);
        for (int i = 0; i < files.length(); ++i) {
            JSONObject file = files.getJSONObject(i);
            String filename = file.getString("filename");
            String contents = file.getString("contents");
            File directory = new File(this.getThemeFolder(), directoryName);
            BrikitFile.ensurePathExists((File)directory);
            BrikitFile.write((String)contents, (File)new File(directory, filename));
        }
    }
}

