/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.WikiRenderException;
import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.BrikitBandanaManager;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitBoolean;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.model.BrikitPageElementDefaults;
import com.brikit.themepress.model.PageWrapper;
import com.brikit.themepress.model.PageWrapperCache;
import com.brikit.themepress.settings.BrikitThemeSettings;
import com.brikit.themepress.settings.SpaceCategorySettings;
import com.brikit.themepress.settings.ThemePlugin;
import com.brikit.themepress.util.ThemePress;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class SpaceWrapper {
    public static final String BRIKIT_THEME_PRESS_DEFAULT_ROOT_PAGE_NAME = ".brikit";
    public static final String BRIKIT_SUPPORT_ROOT_PAGE_DESC = "Theme Press Default Space";
    public static final String BRIKIT_LAYOUT_LANDING_PAGE_TITLE = ".brikit.layout.Landing Page";
    public static final String BRIKIT_LAYOUT_ANNOUNCEMENT_TITLE = ".brikit.layout.Announcement";
    public static final String BRIKIT_LAYOUT_DOCUMENTATION_TITLE = ".brikit.layout.Documentation";
    public static final String BRIKIT_LAYOUT_COMMUNITY_TITLE = ".brikit.layout.Community";
    public static final String BRIKIT_LAYOUT_BASIC_CONFLUENCE_TITLE = ".brikit.layout.Basic Confluence";
    public static final String BRIKIT_BANNER_OLD_DEFAULT_TITLE = ".brikit.banner";
    public static final String BRIKIT_FOOTER_OLD_DEFAULT_TITLE = ".brikit.footer";
    public static final String BRIKIT_HEADER_OLD_DEFAULT_TITLE = ".brikit.header";
    public static final String BRIKIT_LAYOUT_OLD_DEFAULT_TITLE = ".brikit.layout";
    public static final String BRIKIT_MENU_OLD_DEFAULT_TITLE = ".brikit.menu";
    public static final String BRIKIT_FRAME_TITLE_PREFIX = ".brikit.frame";
    public static final String BRIKIT_GRID_TITLE_PREFIX = ".brikit.grid";
    public static final String BRIKIT_HEADER_EMPTY_PAGE_TITLE = ".brikit.header.Empty";
    public static final String BRIKIT_MENU_DEMO_PAGE_TITLE = ".brikit.menu.Demo";
    public static final String BRIKIT_FOOTER_SIMPLE_PAGE_TITLE = ".brikit.footer.Simple";
    public static final String BRIKIT_FOOTER_DEMO_PAGE_TITLE = ".brikit.footer.Demo";
    public static final String BRIKIT_FOOTER_SPLASH_DEMO_PAGE_TITLE = ".brikit.footer.Splash Demo";
    public static final String BRIKIT_FOOTER_VANILLA_DEMO_PAGE_TITLE = ".brikit.footer.Vanilla Demo";
    public static final String BRIKIT_BANNER_EMPTY_PAGE_TITLE = ".brikit.banner.Empty";
    public static final String BRIKIT_BANNER_MAINTENANCE_PAGE_TITLE = ".brikit.banner.Maintenance";
    public static final String BRIKIT_THEME_PRESS_DEFAULT_MOBILE_ROOT_PAGE_NAME = ".brikit.mobile";
    public static final String BRIKIT_MOBILE_PHONE_PAGE_TITLE_SUFFIX = ".mobile.phone";
    public static final String BRIKIT_LAYOUT_PAGE_LABEL = "theme-press-layout";
    public static final String BRIKIT_HEADER_PAGE_LABEL = "theme-press-header";
    public static final String BRIKIT_MENU_PAGE_LABEL = "theme-press-menu";
    public static final String BRIKIT_FOOTER_PAGE_LABEL = "theme-press-footer";
    public static final String BRIKIT_BANNER_PAGE_LABEL = "theme-press-banner";
    public static final String BRIKIT_THEME_PRESS_DEFAULT_SPACE_KEY = "themepressdefault";
    public static final String BRIKIT_THEME_PRESS_DEMO_SPACE_KEY = "themepressdemo";
    public static final String BRIKIT_THEME_PRESS_SPLASH_DEMO_SPACE_KEY = "brikitdemoSPLASH";
    public static final String BRIKIT_THEME_PRESS_VANILLA_DEMO_SPACE_KEY = "brikitdemoVANILLA";
    public static final String BRIKIT_THEME_PRESS_DEFAULT_SPACE_NAME = "Theme Press Default";
    public static final String BRIKIT_THEME_PRESS_DEFAULT_SPACE_DESC = "Pages that define all menus, headers, footers, banners, etc. for Brikit Theme Press";
    public static final String SPACE_THEME_NAME = "com.brikit.space.theme";
    public static final String SITE_THEME_NAME = "com.brikit.site.theme";
    public static final String SPACE_KEY_FOR_MENU_KEY = "com.brikit.space.key.for.menu";
    public static final String OVERRIDE_DEFAULT_KEY_ROOT = "com.brikit.space.override.";
    public static final String OVERRIDE_DEFAULT_BANNER_KEY = "com.brikit.space.override.banner";
    public static final String OVERRIDE_DEFAULT_MENU_KEY = "com.brikit.space.override.menu";
    public static final String OVERRIDE_DEFAULT_HEADER_KEY = "com.brikit.space.override.header";
    public static final String OVERRIDE_DEFAULT_LAYOUT_KEY = "com.brikit.space.override.layout";
    public static final String OVERRIDE_DEFAULT_FOOTER_KEY = "com.brikit.space.override.footer";
    public static final String SPACE_LOGO_OVERRIDE_FILENAME_ROOT = "space-logo";
    protected static final String GLOBAL_CONTEXT = ":::GLOBAL:::";
    protected static Map<String, SpaceWrapper> spaces;
    protected String spaceKey;

    protected SpaceWrapper(Space aSpace) {
        if (aSpace != null) {
            this.setSpaceKey(aSpace.getKey());
        }
    }

    public static SpaceWrapper get(AbstractPage abstractPage) {
        return SpaceWrapper.get(Confluence.getSpace((AbstractPage)abstractPage));
    }

    public static SpaceWrapper get(Space confluenceSpace) {
        return SpaceWrapper.get(confluenceSpace == null ? null : confluenceSpace.getKey());
    }

    public static SpaceWrapper get(String spaceKey) {
        SpaceWrapper space;
        if (!BrikitString.isSet((String)spaceKey)) {
            spaceKey = GLOBAL_CONTEXT;
        }
        if ((space = SpaceWrapper.getSpaces().get(spaceKey)) == null) {
            space = new SpaceWrapper(Confluence.getSpace((String)spaceKey));
            SpaceWrapper.getSpaces().put(spaceKey, space);
        }
        return space;
    }

    protected static Map<String, SpaceWrapper> getSpaces() {
        if (spaces == null) {
            spaces = new HashMap<String, SpaceWrapper>();
        }
        return spaces;
    }

    public static void reset() {
        spaces = null;
    }

    public static SpaceWrapper getThemePressDefaultSpaceWrapper() {
        return SpaceWrapper.get(ThemePress.getThemePressDefaultSpace());
    }

    public Page getBanner() {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getBannerPageTitle(this.getConfluenceSpace()));
    }

    public Page getBlogLayout() {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getBlogLayoutPageTitle(null, this.getConfluenceSpace()));
    }

    public Space getConfluenceSpace() {
        return Confluence.getSpace((String)this.getSpaceKey());
    }

    public Page getFooter() {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getFooterPageTitle(this.getConfluenceSpace()));
    }

    public Page getFooterForPage(AbstractPage viewPage) {
        if (ThemePress.isFooterPage(viewPage)) {
            return (Page)viewPage;
        }
        return BrikitThemeSettings.getArchitectPageForSpace(viewPage, ".brikit.footer.");
    }

    public Page getHeader() {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getHeaderPageTitle(this.getConfluenceSpace()));
    }

    public Page getHeaderForPage(AbstractPage viewPage) {
        if (ThemePress.isHeaderPage(viewPage)) {
            return (Page)viewPage;
        }
        return BrikitThemeSettings.getArchitectPageForSpace(viewPage, ".brikit.header.");
    }

    public String getKey() {
        return this.getConfluenceSpace().getKey();
    }

    public Page getLayout() {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getLayoutPageTitle(null, this.getConfluenceSpace()));
    }

    public Page getMenu() {
        return ThemePress.getArchitectPage(BrikitThemeSettings.getMenuPageTitle(this.getConfluenceSpace()));
    }

    public Page getMenuForPage(AbstractPage viewPage) {
        if (ThemePress.isMenuPage(viewPage)) {
            return (Page)viewPage;
        }
        return BrikitThemeSettings.getArchitectPageForSpace(viewPage, ".brikit.menu.");
    }

    public Page getOrCreateArchitectPageRoot() throws WikiRenderException {
        return Confluence.getOrCreatePageWithWikiMarkup((Space)this.getConfluenceSpace(), (String)BRIKIT_THEME_PRESS_DEFAULT_ROOT_PAGE_NAME, (String)"{children}", (boolean)false);
    }

    public Page getOrCreateArchitectPageWithStorageFormat(String aPageTitle, String xhtmlContent) throws Exception {
        Calendar now = Calendar.getInstance();
        return this.getOrCreateArchitectPageWithStorageFormat(aPageTitle, xhtmlContent, now, now);
    }

    public Page getOrCreateArchitectPageWithStorageFormat(String aPageTitle, String xhtmlContent, Calendar createDate, Calendar updateDate) throws Exception {
        return Confluence.getOrCreatePage((Space)this.getConfluenceSpace(), (String)aPageTitle, (String)xhtmlContent, (boolean)false, (Page)this.getOrCreateArchitectPageRoot(), (Calendar)createDate, (Calendar)updateDate);
    }

    public Page getOrCreateArchitectPageWithWikiMarkup(String pageTitle, String defaultWikiMarkup, Calendar createDate, Calendar updateDate) throws WikiRenderException {
        return Confluence.getOrCreatePageWithWikiMarkup((Space)this.getConfluenceSpace(), (String)pageTitle, (String)defaultWikiMarkup, (boolean)false, (Page)this.getOrCreateArchitectPageRoot(), (Calendar)createDate, (Calendar)updateDate);
    }

    public Page getOrCreateBanner(String aName) throws Exception {
        String pageName = ".brikit.banner." + aName;
        return this.getOrCreateArchitectPageWithStorageFormat(pageName, BrikitPageElementDefaults.getDefaultPageContents(BRIKIT_BANNER_EMPTY_PAGE_TITLE));
    }

    public Page getOrCreateFrame(String aName) throws Exception {
        String pageName = ".brikit.frame." + aName;
        Page frame = this.getOrCreateArchitectPageWithStorageFormat(pageName, "");
        PageWrapper wrapper = PageWrapper.get((AbstractPage)frame);
        wrapper.ensureLayer();
        return frame;
    }

    public Page getOrCreateFooter(String aName) throws Exception {
        String pageName = ".brikit.footer." + aName;
        return this.getOrCreateArchitectPageWithStorageFormat(pageName, BrikitPageElementDefaults.getDefaultPageContents(BRIKIT_FOOTER_SIMPLE_PAGE_TITLE));
    }

    public Page getOrCreateHeader(String aName) throws Exception {
        String pageName = ".brikit.header." + aName;
        return this.getOrCreateArchitectPageWithStorageFormat(pageName, BrikitPageElementDefaults.getDefaultPageContents(BRIKIT_HEADER_EMPTY_PAGE_TITLE));
    }

    public Page getOrCreateLayout(String aName) throws Exception {
        String pageName = ".brikit.layout." + aName;
        return this.getOrCreateArchitectPageWithStorageFormat(pageName, BrikitPageElementDefaults.getDefaultPageContents(BRIKIT_LAYOUT_COMMUNITY_TITLE));
    }

    public Page getOrCreateMobilePageRoot() throws Exception {
        return Confluence.getOrCreatePage((Space)this.getConfluenceSpace(), (String)BRIKIT_THEME_PRESS_DEFAULT_MOBILE_ROOT_PAGE_NAME, (String)BrikitPageElementDefaults.getDefaultPageContents(BRIKIT_THEME_PRESS_DEFAULT_MOBILE_ROOT_PAGE_NAME), (boolean)false);
    }

    public Page getOrCreateOneLevelMenu(String aName) throws Exception {
        String pageName = ".brikit.menu." + aName;
        return this.getOrCreateArchitectPageWithStorageFormat(pageName, BrikitPageElementDefaults.getDefaultPageContents("default-content/default-menu-one-level.txt"));
    }

    public Page getOrCreateTwoLevelMenu(String aName) throws Exception {
        String pageName = ".brikit.menu." + aName;
        return this.getOrCreateArchitectPageWithStorageFormat(pageName, BrikitPageElementDefaults.getDefaultPageContents("default-content/default-menu-two-level.txt"));
    }

    public Page getOrCreatePanelsMenu(String aName) throws Exception {
        String pageName = ".brikit.menu." + aName;
        return this.getOrCreateArchitectPageWithStorageFormat(pageName, BrikitPageElementDefaults.getDefaultPageContents("default-content/default-menu-panels.txt"));
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    protected void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getSpaceKeyForMenu() {
        return this.getValue(SPACE_KEY_FOR_MENU_KEY, null);
    }

    public Attachment getSpaceOverrideLogo() {
        return Confluence.getImageAttachment((AbstractPage)Confluence.getSpaceHomePage((String)this.getSpaceKey()), (String)SPACE_LOGO_OVERRIDE_FILENAME_ROOT);
    }

    public String getSpaceOverrideLogoURL() {
        return Confluence.attachmentDownloadPath((Attachment)this.getSpaceOverrideLogo());
    }

    public String getThemeName() {
        String overrideTheme = BrikitThemeSettings.getOverrideTheme();
        if (BrikitString.isSet((String)overrideTheme)) {
            return overrideTheme;
        }
        String themeName = this.getThemeNameSetting();
        if (!BrikitString.isSet((String)themeName)) {
            themeName = SpaceCategorySettings.getSpaceCategoryThemeName(this.getConfluenceSpace());
        }
        return ThemePlugin.isInstalled(themeName) ? themeName : BrikitThemeSettings.getDefaultThemeName();
    }

    public void setThemeName(String themeName) {
        if (this.getConfluenceSpace() == null) {
            BrikitThemeSettings.setDefaultThemeName(themeName);
        } else {
            this.setValue(SPACE_THEME_NAME, themeName);
        }
    }

    public String getThemeNameSetting() {
        return this.getConfluenceSpace() != null ? this.getValue(SPACE_THEME_NAME, null) : null;
    }

    protected String getValue(String aKey, String defaultValue) {
        return BrikitBandanaManager.getEntry((Space)this.getConfluenceSpace(), (String)aKey, (String)defaultValue);
    }

    public boolean isUsingDefaultBanner() {
        return this.isUsingDefaultPage(OVERRIDE_DEFAULT_BANNER_KEY, "banner");
    }

    public boolean isUsingDefaultMenu() {
        return this.isUsingDefaultPage(OVERRIDE_DEFAULT_MENU_KEY, "menu");
    }

    public boolean isUsingDefaultHeader() {
        return this.isUsingDefaultPage(OVERRIDE_DEFAULT_HEADER_KEY, "header");
    }

    public boolean isUsingDefaultLayout() {
        return this.isUsingDefaultPage(OVERRIDE_DEFAULT_LAYOUT_KEY, "layout");
    }

    public boolean isUsingDefaultFooter() {
        return this.isUsingDefaultPage(OVERRIDE_DEFAULT_FOOTER_KEY, "footer");
    }

    public boolean isUsingDefaultPage(String overrideKey, String defaultPage) {
        String override = this.getValue(overrideKey, null);
        return !BrikitBoolean.booleanValue((String)override);
    }

    public boolean isUsingDefaultTheme() {
        return !BrikitString.isSet((String)this.getThemeNameSetting());
    }

    public void setOverrideDefaultPage(String defaultPage, boolean override) {
        this.setValue(OVERRIDE_DEFAULT_KEY_ROOT + defaultPage, override ? "true" : "false");
        PageWrapperCache.reset();
    }

    public void setOverrideDefaultBanner(boolean override) {
        this.setOverrideDefaultPage("banner", override);
    }

    public void setOverrideDefaultMenu(boolean override) {
        this.setOverrideDefaultPage("menu", override);
    }

    public void setOverrideDefaultHeader(boolean override) {
        this.setOverrideDefaultPage("header", override);
    }

    public void setOverrideDefaultLayout(boolean override) {
        this.setOverrideDefaultPage("layout", override);
    }

    public void setOverrideDefaultFooter(boolean override) {
        this.setOverrideDefaultPage("footer", override);
    }

    protected void setValue(String aKey, String aValue) {
        if (BrikitString.isSet((String)aValue)) {
            BrikitBandanaManager.saveEntry((Space)this.getConfluenceSpace(), (String)aKey, (Object)aValue);
        } else {
            BrikitBandanaManager.deleteEntry((Space)this.getConfluenceSpace(), (String)aKey);
        }
    }
}

