/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.renderer.v2.RenderMode;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitBaseMacro;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.util.BrikitProperties;
import com.brikit.core.util.BrikitString;
import java.util.Map;

public class LiveBlueprintMacro
extends BrikitBaseMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/live-blueprint.vm";
    public static final String PAGE_PARAM = "page";
    public static final String RENDER_IN_BLUEPRINT_CONTEXT_PARAM = "render-in-blueprint-context";

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        AbstractPage blueprint = macroContext.pageFromValue(PAGE_PARAM, null);
        if (blueprint == null) {
            return "";
        }
        String blueprintBody = Confluence.getBodyAsString((ContentEntityObject)blueprint);
        BrikitProperties properties = BrikitString.getProperties((String)body);
        for (Object property : properties.keySet()) {
            String key = (String)property;
            String value = properties.getProperty(key);
            blueprintBody = blueprintBody.replaceAll("\\[\\[" + key + "]]", value);
        }
        AbstractPage renderContext = macroContext.booleanValue(RENDER_IN_BLUEPRINT_CONTEXT_PARAM) ? blueprint : macroContext.getPage();
        macroContext.velocityContextAdd((Object)"body", (Object)Confluence.render((String)blueprintBody, (AbstractPage)renderContext));
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }
}

