/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.model.PageWrapper;

public class RenderPageBlocksAction
extends ThemePressActionSupport {
    public static final String BLOCK_ID_KEY = "blockId";
    public static final String BLOCK_KEY = "block";
    public static final String BLOCKS_KEY = "blocks";

    public String execute() throws Exception {
        try {
            if (!Confluence.canRead((AbstractPage)this.getPage())) {
                throw new Exception("You don't have permission to do this.");
            }
            if (!(this.getPage() instanceof Page)) {
                throw new Exception("Presentations only supported for Confluence pages.");
            }
            PageWrapper pageWrapper = PageWrapper.get(this.getPage());
            JSONArray blocks = new JSONArray();
            for (MacroDefinition blockMacro : pageWrapper.blocksForced()) {
                JSONObject json = new JSONObject();
                json.put(BLOCK_ID_KEY, (Object)MacroParser.getStringParameter((MacroDefinition)blockMacro, (String)"id"));
                json.put(BLOCK_KEY, (Object)Confluence.render((MacroDefinition)blockMacro, (AbstractPage)this.getPage()));
                blocks.put((Object)json);
            }
            JSONObject json = new JSONObject();
            json.put("success", true);
            json.put(BLOCKS_KEY, (Object)blocks);
            this.setResult(json.toString());
            return "success";
        }
        catch (Exception ex) {
            return this.setJSONError(ex.getMessage());
        }
    }
}

