/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.MacroParser;
import com.brikit.core.util.BrikitNumber;
import com.brikit.themepress.model.PageWrapper;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class EditPageAction
extends com.atlassian.confluence.pages.actions.EditPageAction {
    protected String blockId;

    public String doDefault() throws Exception {
        String result = super.doDefault();
        long blockId = BrikitNumber.parseLong((String)this.getBlockId());
        if (blockId < 0L) {
            this.blockId = PageWrapper.get(this.getPage()).addBlocks(-1 * (int)blockId);
            return "blocksAdded";
        }
        MacroDefinition macro = this.getBlockMacro();
        if (macro != null) {
            this.setWysiwygContent(Confluence.convertToEditorContent((String)macro.getBodyText(), (AbstractPage)this.getPage()));
        }
        return result;
    }

    public String getBlockId() {
        return this.blockId;
    }

    protected MacroDefinition getBlockMacro() throws XhtmlException {
        PageWrapper wrapper = PageWrapper.getBypassingCache(this.getPage());
        return wrapper == null ? null : wrapper.block(this.getBlockId());
    }

    @StrutsParameter
    public void setBlockId(String blockId) {
        this.blockId = blockId;
    }

    public void validate() {
        super.validate();
        try {
            MacroDefinition macro = this.getBlockMacro();
            if (macro != null) {
                this.storageFormat = MacroParser.replaceMacroBodyOnPage((AbstractPage)this.getPage(), (MacroDefinition)macro, (String)this.storageFormat);
            }
        }
        catch (Exception ex) {
            this.addActionError(this.getText("brikit.block.content.replacement.failed"), new Object[]{ex});
        }
    }
}

